//
//  YHCertificateInfoPhotoCell.swift
//  galaxy
//
//  Created by edy on 2024/8/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCertificateInfoPhotoCell: UITableViewCell {

    static let cellReuseIdentifier = "YHCertificateInfoPhotoCell"

    lazy var infoImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "family_certificate_info"))
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(infoImgView)
        infoImgView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(0)
            make.bottom.equalTo(0)
            make.height.equalTo(infoImgView.snp.width).multipliedBy(2467.0/343.0)
        }
    }
}
